/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.ConnectionPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectionUDFPanel
extends ConnectionPanel {
    public static final String CONNECTION_UDF = "Connection_UDF";
    protected static final String UDF_ICON = "UDFDefaultIcon.gif";
    protected Color fHighColor = Global.SIMULATION_COLOR_HIGH;
    protected Color fLowColor = Global.SIMULATION_COLOR_LOW;

    public ConnectionUDFPanel(Color highColor, Color lowColor) {
        this.fHighColor = highColor;
        this.fLowColor = lowColor;
    }

    public Color getDefaultColor() {
        return new Color(128, 0, 128);
    }

    public String getKey() {
        String key = CONNECTION_UDF;
        return key;
    }

    public String getPreviewName() {
        return Language.getString("dialog.options.color.simulation.udf", "Simulation UDF block outline");
    }

    protected JPanel getPreviewPanel() {
        if (this.fPreviewPanel == null) {
            this.fPreviewPanel = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    Dimension size = this.getSize();
                    int xCenter = size.width / 2;
                    int figureLeftX = xCenter - 12;
                    int figureRightX = xCenter + 12;
                    int offset = 9;
                    g.setColor(ConnectionUDFPanel.this.fHighColor);
                    g.drawLine(figureLeftX - 50, offset, figureLeftX, offset);
                    offset = 17;
                    g.setColor(ConnectionUDFPanel.this.fHighColor);
                    g.drawLine(figureLeftX - 50, offset, figureLeftX, offset);
                    offset = 25;
                    g.setColor(ConnectionUDFPanel.this.fLowColor);
                    g.drawLine(figureLeftX - 50, offset, figureLeftX, offset);
                    offset = 33;
                    g.setColor(ConnectionUDFPanel.this.fLowColor);
                    g.drawLine(figureLeftX - 50, offset, figureLeftX, offset);
                    offset = 13;
                    g.setColor(ConnectionUDFPanel.this.fHighColor);
                    g.drawLine(figureRightX, offset, figureRightX + 50, offset);
                    offset = 22;
                    g.setColor(ConnectionUDFPanel.this.fLowColor);
                    g.drawLine(figureRightX, offset, figureRightX + 50, offset);
                    offset = 31;
                    g.setColor(ConnectionUDFPanel.this.fLowColor);
                    g.drawLine(figureRightX, offset, figureRightX + 50, offset);
                }
            };
            this.fPreviewPanel.setLayout(new FlowLayout());
            this.fPreviewPanel.setBackground(this.fBackgroundColor);
            this.fPreviewPanel.add(this.getConnectionLabel());
            this.fPreviewPanel.add(this.getInputLabel());
            this.fPreviewPanel.add(this.getOutputLabel());
            this.setConnectionColor(this.getColor());
        }
        return this.fPreviewPanel;
    }

    protected JLabel getInputLabel() {
        if (this.fInputLabel == null) {
            this.fInputLabel = new JLabel(this.getFBImageIcon(UDF_ICON, this.fFBBgColor)){

                public void paint(Graphics g) {
                    super.paint(g);
                    Dimension size = this.getSize();
                    g.drawRect(0, 0, size.width - 1, size.height - 1);
                }
            };
        }
        return this.fInputLabel;
    }

    protected JLabel getOutputLabel() {
        if (this.fOutputLabel == null) {
            this.fOutputLabel = new JLabel("           ");
        }
        return this.fOutputLabel;
    }

    protected JLabel getConnectionLabel() {
        this.fconnection = new JLabel("           ");
        return this.fconnection;
    }

    protected void setConnectionColor(Color color) {
        this.fInputLabel.setForeground(color);
        this.fconnection.setForeground(color);
        this.getPreviewPanel().setForeground(color);
    }

    public void setHighColor(Color highColor) {
        this.fHighColor = highColor;
    }

    public void setLowColor(Color lowColor) {
        this.fLowColor = lowColor;
    }
}

